/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.ConfigDataHolderImpl;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.config.annotation.AnnotatedConfigBuilder;
import fuzs.puzzleslib.config.core.AbstractConfigBuilder;
import fuzs.puzzleslib.config.core.FabricConfigBuilderWrapper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;

class FabricConfigDataHolderImpl<T extends ConfigCore>
extends ConfigDataHolderImpl<T> {
    private final ModConfig.Type configType;
    @Nullable
    private ModConfig modConfig;

    public FabricConfigDataHolderImpl(ModConfig.Type configType, Supplier<T> config) {
        super(config);
        this.configType = configType;
        this.fileName = modId -> ConfigHolder.defaultName(modId, configType.extension());
    }

    @Override
    protected void testAvailable() {
        this.findErrorMessage().ifRight(message -> PuzzlesLib.LOGGER.error("Calling {} config when it is not yet available! This is a bug! Message: {}", new Object[]{this.configType.extension(), message, new Exception("Config not yet available")}));
    }

    @Override
    protected Either<Unit, String> findErrorMessage() {
        if (this.modConfig == null) {
            return Either.right((Object)"Mod config instance is missing");
        }
        if (this.modConfig.getConfigData() == null) {
            return Either.right((Object)"Config data is missing");
        }
        if (!this.available) {
            return Either.right((Object)"Config callbacks have not been loaded");
        }
        return Either.left((Object)Unit.INSTANCE);
    }

    public void onModConfig(ModConfig config, boolean reloading) {
        Objects.requireNonNull(this.config, "Attempting to register invalid config of type %s for mod id %s".formatted(this.configType.extension(), config.getModId()));
        if (config.getType() == this.configType && (this.modConfig == null || config == this.modConfig)) {
            String loading;
            if (config.getConfigData() != null) {
                this.available = true;
                loading = reloading ? "Reloading" : "Loading";
                this.configValueCallbacks.forEach(Runnable::run);
                this.additionalCallbacks.forEach(Runnable::run);
            } else {
                this.available = false;
                loading = "Unloading";
            }
            PuzzlesLib.LOGGER.info("{} {} config for {}", new Object[]{loading, config.getType().extension(), config.getModId()});
        }
    }

    public void register(ModConfigFactory factory) {
        Objects.requireNonNull(this.config, "Attempting to register invalid config of type %s".formatted(this.configType.extension()));
        if (this.modConfig != null) {
            throw new IllegalStateException(String.format("Config for type %s has already been registered!", this.configType));
        }
        this.modConfig = factory.createAndRegister(this.configType, this.buildSpec(), this.fileName);
    }

    private ForgeConfigSpec buildSpec() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        AnnotatedConfigBuilder.serialize((AbstractConfigBuilder)new FabricConfigBuilderWrapper(builder), this, this.config);
        this.configValueCallbacks = ImmutableList.copyOf((Collection)this.configValueCallbacks);
        return builder.build();
    }

    static interface ModConfigFactory {
        public ModConfig createAndRegister(ModConfig.Type var1, ForgeConfigSpec var2, UnaryOperator<String> var3);
    }
}

